/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.regex.Pattern;

public class ImageTools {
    public static final int PROGRESS_INTERVAL = 5;
    private static final Pattern SCALED_FILE_PATTERN = Pattern.compile(".*@[1-9][0-9]?x(?:\\.[^\\.]+)?");

    public static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2;
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (n2 > 0) {
            int n4 = inputStream.read(byArray, n, n2);
            if (n4 == -1) {
                throw new EOFException();
            }
            n += n4;
            n2 -= n4;
        }
        return n3;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return ImageTools.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 <= 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException();
                }
                --l;
                continue;
            }
            l -= l2;
        }
    }

    public static String getScaledImageName(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.lastIndexOf(47);
        String string2 = n2 < 0 ? string : string.substring(n2 + 1);
        int n3 = string2.lastIndexOf(".");
        if (n3 < 0) {
            n3 = string2.length();
        }
        if (n2 >= 0) {
            stringBuilder.append(string.substring(0, n2 + 1));
        }
        stringBuilder.append(string2.substring(0, n3));
        stringBuilder.append("@");
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(string2.substring(n3));
        return stringBuilder.toString();
    }

    public static boolean hasScaledName(String string) {
        return SCALED_FILE_PATTERN.matcher(string).matches();
    }

    public static InputStream createInputStream(String string) throws IOException {
        Serializable serializable;
        InputStream inputStream = null;
        try {
            serializable = new File(string);
            if (((File)serializable).exists()) {
                inputStream = new FileInputStream((File)serializable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            serializable = new URL(string);
            inputStream = ((URL)serializable).openStream();
        }
        return inputStream;
    }

    public static int[] computeDimensions(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = n3 < 0 ? 0 : n3;
        int n7 = n5 = n4 < 0 ? 0 : n4;
        if (n6 == 0 && n5 == 0) {
            n6 = n;
            n5 = n2;
        } else if (n6 != n || n5 != n2) {
            if (bl) {
                if (n6 == 0) {
                    n6 = Math.round((float)n * (float)n5 / (float)n2);
                } else if (n5 == 0) {
                    n5 = Math.round((float)n2 * (float)n6 / (float)n);
                } else {
                    float f = Math.min((float)n6 / (float)n, (float)n5 / (float)n2);
                    n6 = Math.round((float)n * f);
                    n5 = Math.round((float)n2 * f);
                }
            } else {
                if (n5 == 0) {
                    n5 = n2;
                }
                if (n6 == 0) {
                    n6 = n;
                }
            }
            if (n6 <= 0) {
                n6 = 1;
            }
            if (n5 <= 0) {
                n5 = 1;
            }
        }
        return new int[]{n6, n5};
    }

    public static void validateMaxDimensions(double d, double d2, double d3) {
        if (d * d3 > 2.147483647E9) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image width exceeds maximum value (width = %f, scale = %f)", d, d3));
        }
        if (d2 * d3 > 2.147483647E9) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image height exceeds maximum value (height = %f, scale = %f)", d2, d3));
        }
        if ((long)(d * d3) * (long)(d2 * d3) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Image size exceeds maximum value (width = %f, height = %f, scale = %f)", d, d2, d3));
        }
    }

    public static ImageFrame scaleImageFrame(ImageFrame imageFrame, int n, int n2, boolean bl) {
        int n3 = ImageStorage.getInstance().getNumBands(imageFrame.getImageType());
        ByteBuffer byteBuffer = ImageTools.scaleImage((ByteBuffer)imageFrame.getImageData(), imageFrame.getWidth(), imageFrame.getHeight(), n3, n, n2, bl);
        return new ImageFrame(imageFrame.getImageType(), byteBuffer, n, n2, n * n3, imageFrame.getMetadata());
    }

    public static ByteBuffer scaleImage(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        PushbroomScaler pushbroomScaler = ScalerFactory.createScaler(n, n2, n3, n4, n5, bl);
        int n6 = n * n3;
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            for (int i = 0; i != n2; ++i) {
                pushbroomScaler.putSourceScanline(byArray, i * n6);
            }
        } else {
            byte[] byArray = new byte[n6];
            for (int i = 0; i != n2; ++i) {
                byteBuffer.get(byArray);
                pushbroomScaler.putSourceScanline(byArray, 0);
            }
        }
        return pushbroomScaler.getDestination();
    }
}

