/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.beans.property;

import java.util.Objects;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;

public abstract class NullCoalescingPropertyBase<T>
extends ObjectPropertyBase<T> {
    private final ChangeListener<T> listener = (observableValue, object, object2) -> {
        this.invalidated();
        this.fireValueChangedEvent();
    };
    private final WeakChangeListener<T> weakListener = new WeakChangeListener(this.listener);
    private final ObservableValue<T> baseObservable;
    private boolean currentValueChanged;
    private T currentValue;

    protected NullCoalescingPropertyBase(ObservableValue<T> observableValue2) {
        this.baseObservable = Objects.requireNonNull(observableValue2, "baseObservable");
        this.currentValue = observableValue2.getValue();
    }

    public final void connect() {
        this.baseObservable.addListener(this.weakListener);
        this.invalidated();
        this.fireValueChangedEvent();
    }

    public final void disconnect() {
        this.baseObservable.removeListener(this.weakListener);
    }

    public final T get() {
        return this.currentValue;
    }

    protected final void fireValueChangedEvent() {
        if (this.currentValueChanged) {
            this.currentValueChanged = false;
            super.fireValueChangedEvent();
        }
    }

    protected final void invalidated() {
        Object object;
        Object object2 = super.get();
        Object object3 = object = object2 != null ? object2 : this.baseObservable.getValue();
        if (this.currentValue != object) {
            this.currentValue = object;
            this.currentValueChanged = true;
            this.onInvalidated();
        }
    }

    protected void onInvalidated() {
    }
}

