/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

public final class TextPos
implements Comparable<TextPos> {
    public static final TextPos ZERO = new TextPos(0, 0, 0, true);
    private final int index;
    private final int offset;
    private final int charIndex;
    private final boolean leading;

    public TextPos(int n, int n2, int n3, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("charIndex cannot be negative");
        }
        this.index = n;
        this.offset = n2;
        this.charIndex = n3;
        this.leading = bl;
    }

    public static TextPos ofLeading(int n, int n2) {
        return new TextPos(n, n2, n2, true);
    }

    public int index() {
        return this.index;
    }

    public int offset() {
        return this.offset;
    }

    public int charIndex() {
        return this.charIndex;
    }

    public boolean isLeading() {
        return this.leading;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TextPos) {
            TextPos textPos = (TextPos)object;
            return this.index == textPos.index && this.charIndex == textPos.charIndex && this.offset == textPos.offset && this.leading == textPos.leading;
        }
        return false;
    }

    public int hashCode() {
        int n = TextPos.class.hashCode();
        n = 31 * n + this.index;
        n = 31 * n + this.charIndex;
        n = 31 * n + this.offset;
        n = 31 * n + (this.leading ? 1 : 0);
        return n;
    }

    @Override
    public int compareTo(TextPos textPos) {
        int n = this.index - textPos.index;
        if (n == 0) {
            int n2;
            int n3 = this.offset();
            if (n3 < (n2 = textPos.offset())) {
                return -1;
            }
            if (n3 > n2) {
                return 1;
            }
            if (this.leading != textPos.leading) {
                return this.leading ? 1 : -1;
            }
            return 0;
        }
        return n;
    }

    public String toString() {
        return "TextPos{index=" + this.index + ", offset=" + this.offset + ", charIndex=" + this.charIndex + ", leading=" + this.leading + "}";
    }

    public boolean isSameInsertionIndex(TextPos textPos) {
        if (textPos != null && this.index == textPos.index) {
            return this.offset == textPos.offset;
        }
        return false;
    }
}

